import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {

    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: sync("camera.upX")
        upY: sync("camera.upY")
        upZ: sync("camera.upZ")
        yawLA: sync("camera.yawLA")
        pitchLA: sync("camera.pitchLA")
    }

    property real t: rocket.time
    Timer {
        interval: 5
        running: true
        repeat: true
        onTriggered: {
            t = rocket.time;
        }
    }

    RenderTarget {
        RenderTargetLayer {
            textureRT: "headPointers"
            format: "R32UI"
            width: 1280
            height: 720
            Clear {
                // cR: 1.0; cG: 1.0; cB: 1.0; cA: 1.0;
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }

    property int layersSquareRoot: 4

    RenderTarget {
        RenderTargetLayer {
            textureRT: "nextPointers"
            format: "R32UI"
            width: 1280*layersSquareRoot
            height: 720*layersSquareRoot
            //            Clear {
            //                // cR: 1.0; cG: 1.0; cB: 1.0; cA: 1.0;
            //                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            //            }
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: "pixelListColors"
            format: "RGBA16F"
            width: 1280*layersSquareRoot
            height: 720*layersSquareRoot
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: "pixelListDepthNorm"
            format: "RGBA32F"
            width: 1280*layersSquareRoot
            height: 720*layersSquareRoot
            Clear {
                // cR: 1.0; cG: 1.0; cB: 1.0; cA: 1.0;
                cR: 1.0; cG: 1.0; cB: 1.0; cA: 1.0;
            }
        }
    }


    Texture {
        textureUnit: 0
        imageUnit: 0
        textureRT: "headPointers"
    }
    Texture {
        textureUnit: 1
        imageUnit: 1
        textureRT: "nextPointers"
    }
    Texture {
        textureUnit: 2
        imageUnit: 2
        textureRT: "pixelListColors"
    }
    Texture {
        textureUnit: 3
        imageUnit: 3
        textureRT: "pixelListDepthNorm"
    }


    TextureImage {
        textureUnit: 1
        file: "../../images/_SK57414_normal.png"
    }
    Texture {
        textureUnit: 2
        textureItem: kuvasEnv
        Image {
            id: kuvasEnv
            visible: false
            source: "../../images/area_lights.jpg"
        }
    }
    Texture {
        textureUnit: 3
        //file: "../../images/StarDust1.jpg"
        //file: "../../images/aalto.png"
        // file: "../../images/PinkMedusa.png"
        // textureRT: "prev"
        textureRT: "prev"
    }
    Texture {
        textureUnit: 4
        textureRT: "prevBlur"
    }
    Texture {
        textureUnit: 5
        textureRT: "prevNormal"
    }

    ShaderAtomicCounter {
        property string name: "sac1"
        id: sac
    }

    Shader { file: "smPlastic" }
    TextureImage {
        textureUnit: 0
       // file: "../../images/_SK57414.png"
        //file: "../../images/PinkMedusaB.png"
        file: "../../images/scratch1.png"
       // file: "../../images/meteor.png"
        //file: "../../images/kivitex1s.png"
       // file: "../../images/siniku4.png"
    }
    DrawMesh {
        Clear { cR: 0.0; cG: 0.0; cB: 0.0 }
        property string name: "mesh2"
      //    file: "mesh/puppet_jump.dae"
      //  file: "mesh/Cave.dae"
        file: "mesh/parkki_halli.dae"
        //file: "mesh/ball5000.x"
        //file: "mesh/400x400.obj"
        Pos { x: 0.0; y: -2.0; z: 0.0; }
        Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
        Sca { s: 20.50; x: 1.0; y: 1.0; z: 1.0 }

        smoothNormals: true
        normalSmoothAngle: 20

        ShaderParam { paramName: "g_uvScale"; paramValue: 0.20}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.005 }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount") }

        blendMode: "off"
        depthTest: true
        depthWrite: true
    }

    TextureImage {
        textureUnit: 0
        // file: "../../images/kivitex1s.png"
        //  file: "../../images/PinkMedusa.png"
        file: "../../images/aalto.png"
        //file: "../../images/huntualpha1.png"
        //file: "../../images/noisep1s.png"
    }
    //    DrawMesh {
    //     //   Clear { cR: 0.0; cG: 0.0; cB: 0.0 }
    //        property string name: "mesh2"
    //        // file: "mesh/hand1b.x"
    //        //file: "mesh/pillarman.obj"
    //        file: "mesh/Cave.dae"
    //        //file: "mesh/ball5000.x"
    //        depthTest: true
    //        depthWrite: true
    //        blendMode: "off"
    //        ShaderParam {
    //            paramName: "g_uvScale"; paramValue: 1.0
    //        }
    //        Pos { x: 2.0; y: -0.50; z: 1.0; }
    //        Sca { s: 0.150; x: 1.0; y: 1.0; z: 1.0 }
    //        Rot { d: 0.0; ax: 1.0; ay: 0.0; az: 0.0 }
    //        Rot { d: 180.0; ax: 1.0; ay: 0.0; az: 0.0 }
    //    }

    //    DrawMesh {
    //     //   Clear { cR: 0.0; cG: 0.0; cB: 0.0 }
    //        property string name: "mesh2"
    //        // file: "mesh/hand1b.x"
    //        file: "mesh/pillarman.obj"
    //        //file: "mesh/Cave.dae"
    //        //file: "mesh/ball5000.x"
    //        depthTest: true
    //        depthWrite: true
    //        blendMode: "off"
    //        ShaderParam {
    //            paramName: "g_uvScale"; paramValue: 1.0
    //        }
    //        Pos { x: 2.0; y: -1.0; z: 1.0; }
    //        Sca { s: 2.0; x: 1.0; y: 1.0; z: 1.0 }
    //        Rot { d: 0.0; ax: 1.0; ay: 0.0; az: 0.0 }
    //        Rot { d: 0.0; ax: 1.0; ay: 0.0; az: 0.0 }
    //    }

    DrawMesh {
        //   Clear { cR: 0.0; cG: 0.0; cB: 0.0 }
        property string name: "mesh2"
        //file: "mesh/cube.x"
        //file: "mesh/ball5000.x"
        //file: "mesh/kolkkus.x"
        //file: "mesh/aivob.x"
        file: "mesh/puppet_jump.dae"
        depthTest: true
        depthWrite: true
        blendMode: "off"
        ShaderParam { paramName: "g_uvScale"; paramValue: 1.0 }
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.0 }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount") }


        Pos { x: 2.0; y: -1.0; z: 1.0; }
        Sca { s: 6.0; x: 1.0; y: 1.0; z: 1.0 }
       // Rot { d: demoTime()*30.0; ax: 1.0; ay: 1.0; az: 0.0 }

        SavePoint {
            target: "cen"
            x: 0.0; y: 0.0; z: 0.0;
        }

        property real rad: 0.23;

        SavePoint { target: "cor1"; x: parent.rad; y: parent.rad; z: parent.rad; }
        SavePoint { target: "cor2"; property real rad: 0.2; x: -parent.rad; y: parent.rad; z: parent.rad; }
        SavePoint { target: "cor3"; property real rad: 0.2; x: parent.rad; y: -parent.rad; z: parent.rad; }
        SavePoint { target: "cor4"; property real rad: 0.2; x: -parent.rad; y: -parent.rad; z: parent.rad; }
        SavePoint { target: "cor5"; x: parent.rad; y: parent.rad; z: -parent.rad; }
        SavePoint { target: "cor6"; property real rad: 0.2; x: -parent.rad; y: parent.rad; z: -parent.rad; }
        SavePoint { target: "cor7"; property real rad: 0.2; x: parent.rad; y: -parent.rad; z: -parent.rad; }
        SavePoint { target: "cor8"; property real rad: 0.2; x: -parent.rad; y: -parent.rad; z: -parent.rad; }

    }

    property real cornerBallsSize: 1.50;

    Repeater {
        id: cornerMesh
        model: 8
        delegate: DrawMesh {
            property string name: "mesh2"
            file: "mesh/ball5000.x"
            //file: "mesh/cube.x"
            //file: "mesh/adaptlogo.obj"
            depthTest: true
            depthWrite: true
            blendMode: "off"
            ShaderParam {
                paramName: "g_uvScale"; paramValue: 1.0
            }
            ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount") }
            property string num: index+1
            Pos { x: getSavePointX("cor"+parent.num); y: getSavePointY("cor"+parent.num); z: getSavePointZ("cor"+parent.num); }
            Rot { d: 0.0; ax: 1.0; ay: 0.0; az: 0.0 }
            Sca { s: cornerBallsSize; x: 1.0; y: 1.0; z: 1.0 }
        }
    }

    Blit {
        textureRT: "bg"
        blitRT: 0
    }
    Blit {
        textureRT: "depth"
        blitRT: 1
    }

//    DrawMesh {
//        Clear { cR: 0.0; cG: 0.0; cB: 0.0 }
//        property string name: "mesh2"
//        //file: "mesh/Drill002.dae"
//        // file: "mesh/cone1.obj"
//        // file: "mesh/ball5000.x"
//        //        Pos { x: sync("drill.x"); y: sync("drill.y"); z: sync("drill.z"); }
//        //        Rot { d: sync("drillRot"); ax: 0.0; ay: 1.0; az: 0.0 }
//        Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
//    }

//    PartSim {
//        name: "credits"

//        simShader: "simPart"
//        //drawShader: "partBalls"
//        //drawBlendMode: "off"
//        drawShader: "partWater"
//        drawBlendMode: "add"

//        // max particles count is gridDimension*gridDimension
//        // CHANGE PROPOSAL: make a new parameter maxPoints instead...
//        gridDimension: 1000

//        // This is actually the number of points drawn for the first frame
//        // of the simulation (or when reset).
//        // As after that, the simulation will continue with own number of particles
//        // as some particles might die and others might emit new ones...
//        // CHANGE PROPOSAL: because of the above explanation, change this variable name to
//        // initNumPoints instead ...
//        drawNumPoints: 10000

//        partSize: sync(name+".partSize")
//        //  partEmitShapeImage: "../../images/black.png"
//        //partEmitShapeImage: "../../images/PinkMedusa.png"
//    }

//    TextureImage {
//        textureUnit: 0
//        // file: "../../images/kivitex1s.png"
//        //  file: "../../images/PinkMedusa.png"
//        file: "../../images/aalto.png"
//        //file: "../../images/huntualpha1.png"
//        //file: "../../images/noisep1s.png"
//    }

//    Shader { file: "smPlastic" }

//    Blit {
//        textureRT: "prevFrame"
//    }
//    Blit {
//        textureRT: "prevFrame2"
//        blitRT: 1
//    }

//    Texture {
//        textureUnit: 0
//        textureRT: "prevFrame"
//    }

////    BlurWithDepth {
////    }

////    Blit {
////        textureRT: "prevFrame"
////    }
//    Texture {
//        textureUnit: 0
//        textureRT: "prevFrame"
//    }
//    Texture {
//        textureUnit: 2
//        textureRT: "prevFrame2"
//    }

//    Texture {
//        textureUnit: 1
//        textureRT: "bg"
//        //textureRT: "depth"
//    }
//    Shader {
//        //file: "mixBalls"
//        file: "mixWater"
//    }

//    DrawVB {
//        ShaderParam {
//            paramName: "flip"
//            paramValue: group.flip ? 1.0 : 0.0
//        }
//        ShaderParam {
//            paramName: "g_bgAmount"; paramValue: sync("bgAmount")
//        }
//        ShaderParam {
//            paramName: "g_lightAmount"; paramValue: sync("lightAmount")
//        }
//        ShaderParam {
//            paramName: "g_waterClip"; paramValue: sync("waterClip")
//        }
//        ShaderParam {
//            paramName: "g_bumpStrength"; paramValue: sync("bumpStrength")
//        }


//        ShaderParam {
//            paramName: "g_overlayScale"; paramValue: overlayScale
//        }
//        ShaderParam {
//            paramName: "g_posX"; paramValue: group.posX
//        }
//        ShaderParam {
//            paramName: "g_posY"; paramValue: group.posY
//        }

//        type: "quad"
//        depthTest: false
//        depthWrite: false
//    }


//    Texture {
//        textureUnit: 3
//        textureRT: "bg"
//    }
//    Texture {
//        textureUnit: 4
//        textureRT: "depth"
//    }
//    BlurDepth {
//    }

//    TextureImage {
//        textureUnit: 0
//        // file: "../../images/kivitex1s.png"
//        //file: "../../images/PinkMedusa.png"
//        //file: "../../images/aalto.png"
//        //file: "../../images/huntualpha1.png"
//        //file: "../../images/noisep1s.png"
//        //file: "../../images/dust2.png"
//        //file: "../../images/apoks.png"
//        file: "../../images/m/apo7.png"
//        //file: "../../images/m/bok.png"
//    }
//    property string shaderVaryings: "
//        vec3 posG;
//        vec2 uvG;
//        vec3 velG;
//        float ageG;
//        float recG;
//        float ageSplitG;
//        vec4 posInitG;"

//    Shader { file: "smPlasticInst" }
//    DrawMesh {
//        property string name: "mesh333"
//        //file: "mesh/cube.x"
//        file: "mesh/ball5000.x"
//        //file: "mesh/kolkkus.x"
//        //file: "mesh/aivob.x"
//        //file: "mesh/rinkula.obj"
//        //file: "mesh/seitti.x"
//        //file: "mesh/hand1b.x"
//        //file: "mesh/pillarman.obj"
//        depthTest: true
//        depthWrite: false
//        blendMode: "add"
//        instanceVBO: sceneName+"credits"
//        instanceCount: 200
//        tfVaryings: shaderVaryings

//        ShaderParam { paramName: "g_uvScale"; paramValue: 1.0 }
//        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.0010 }
//        // Pos { x: 0.0; y: 0.0; z: 0.0; }
//        Sca { s: 0.70; }
//        // Rot { d: 0.0; ax: 0.0; ay: 1.0; az: 0.0 }
//    }


    Shader { file: "smDeform" }
    DrawMesh {
        //   Clear { cR: 0.0; cG: 0.0; cB: 0.0 }
        property string name: "mesh2"
       // file: "mesh/puppet_jump.dae"
        file: "mesh/cube.x"
        //file: "mesh/ball5000.x"
        //file: "mesh/kolkkus.x"
      //  file: "mesh/aivob.x"
       // file: "mesh/aivouge_lowpoly.lwo"
        //file: "mesh/pillarman.obj"
        depthTest: true
        depthWrite: true
        blendMode: "normal"
        ShaderParam {
            paramName: "g_uvScale"; paramValue: 2.0
        }
        Pos { x: 2.0; y: -1.0; z: 1.0; }
        Rot { d: demoTime()*0.0; ax: 1.0; ay: 1.0; az: 0.0 }
        Sca { s: 4.0; x: 1.10; y: 3.10; z: 100.10 }
    }

    DrawMesh {
        file: "mesh/cube.x"
       // file: "mesh/ball5000.x"
       // file: "mesh/kolkkus.x"
        //file: "mesh/aivob.x"
        //file: "mesh/pillarman.obj"
        depthTest: true
        depthWrite: true
        blendMode: "normal"
        ShaderParam {
            paramName: "g_uvScale"; paramValue: 2.0
        }
        Pos { x: 0.0; y: 2.20; z: 0.0+0.0*Math.sin(demoTime()*0.05); }
        Rot { d: demoTime()*0.0+90; ax: 1.0; ay: 0.0; az: 0.0 }
        Sca { s: 5.0; x: 0.40; y: 1.10; z: 20.0 }
    }


//    DrawMesh {
//        //   Clear { cR: 0.0; cG: 0.0; cB: 0.0 }
//        property string name: "mesh2"
//        //file: "mesh/cube.x"
//        //file: "mesh/ball5000.x"
//        //file: "mesh/kolkkus.x"
//        //file: "mesh/aivob.x"
//        file: "mesh/puppet_jump.dae"
//        depthTest: true
//        depthWrite: true
//        blendMode: "off"
//        ShaderParam { paramName: "g_uvScale"; paramValue: 1.0 }
//        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.0 }
//        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
//        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount") }


//        Pos { x: 2.0; y: -1.0; z: 1.0; }
//        Sca { s: 6.0; x: 1.0; y: 1.0; z: 1.0 }
//       // Rot { d: demoTime()*30.0; ax: 1.0; ay: 1.0; az: 0.0 }

//    }


//    DrawMesh {
//        //   Clear { cR: 0.0; cG: 0.0; cB: 0.0 }
//        property string name: "mesh2"
//        //file: "mesh/cube.x"
//        file: "mesh/ball5000.x"
//        //file: "mesh/kolkkus.x"
//        //file: "mesh/aivob.x"
//        //file: "mesh/pillarman.obj"
//        depthTest: true
//        depthWrite: true
//        blendMode: "off"
//        ShaderParam {
//            paramName: "g_uvScale"; paramValue: 2.0
//        }
//        Pos { x: 1.0; y: 1.50; z: 3.0; }
//        Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
//        Rot { d: demoTime()*30.0; ax: 1.0; ay: 1.0; az: 0.0 }
//    }

    Blit { textureRT: "prevNormal"; blitRT: 1 }

    GodRay {
        // godRayX: sync("godray.x")
        // godRayY: sync("godray.y")
        godRayX: getSavePointX2D("cen")
        godRayY: getSavePointY2D("cen")
    }

    Glow {
    }


    Blit { textureRT: "prev" }
    Blur {}
    Blit { textureRT: "prevBlur" }
    Texture {
        textureUnit: 0
        textureRT: "prevNormal"
    }
    Shader {
        file: "drawRt"
    }
    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false
        ShaderParam {
            paramName: "flip"
            paramValue: 1.0
        }
        blendMode: "off"
    }
    Blur {}
    Blit { textureRT: "prevNormal"; blitRT: 0 }


    Texture {
        textureUnit: 0
        textureRT: "prev"
    }
    Shader {
        file: "drawRt"
    }
    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false
        ShaderParam {
            paramName: "flip"
            paramValue: 1.0
        }
        blendMode: "off"
    }



    Reflect {

    }



    Tonemap { }

    Vignette {
        posX: 0.0
        posY: 0.0
    }

    Shader { file: "smCoords" }
    Coords { }

}
